/*
    Project: FlexiBarDemo
    File: main.cpp

    Test harness for flexiBar bar graph display function.

    Written by: Dr. C. S. Tritt
    Created: 9/13/17 (v. 1.0)
*/
#include "mbed.h"
#include <flexiBar.h>

// Create 10-bit BusOut object called barGraph.
BusOut barGraph(D11, D10, D9, D8, D7, D6, D5, D4, D3, D2);

int main() {

    printf("flexiBar Test Harness\n"); // ID software.
    
    // Start by directly testing the display.
    barGraph = 0b1111111111;  // Light all bars.
    wait(2.0);
    barGraph = 0;  // All bars off.
    wait(2.0);
    
    // Loop through all values in both modes.
    while(true) {
        bool single = true;
        for (int n = 0; n <= 9; n++) {
            flexiBar(n, barGraph, single, true);
            wait(1.0);
        }
        single = false;
        for (int n = 0; n <= 9; n++) {
            flexiBar(n, barGraph, single, true);
            wait(1.0);
        }
        // Test the special case of all bars off. Third argument is ignored.
        flexiBar(-1, barGraph, false, true);
        wait(2.0);   
    }
}