/*
Project: FanPWM

Serial control of fan using PWM. This is just a crude test program. Blocking
on serial input is poor design.

Created by Dr. C. S. Tritt
Created: 4/17/18 (v. 1.0)

*/

#include "mbed.h"

Serial pc(USBTX, USBRX); // Default settings are 9600 Baud, 8-N-1.
PwmOut myPWM(D13); // PB_3, D3 Works on CE Dev Board.

DigitalOut myLED(LED1);

int main() 
{
    pc.printf("\n\nThis is FanPWM v. 1.1.\n");
    pc.printf("Set Terminal > Local echo.\nSet New-lines to LF.\n");
    pc.printf("PWM output is pin D13.\n");
    float myValue = 0.50; // Initialize to default value. Use for input.
    myPWM.write(myValue);
    pc.printf("PWM set to %0.2f by default.\n", myPWM.read()); // Read value.

    
    while(1) {
        myLED = !myLED; // Toggle onboard LED each cycle.
        pc.printf("Enter new value (between 0.0 and 1.0): ");
        // Program blocks here waiting for input.
        pc.scanf("%f", &myValue);
        pc.printf("\n"); // Advance cursor.
        
        if (myValue < 0.0f) {
            pc.printf("Value less than zero, set to zero.\n");
            myValue = 0.0f;
        }
        else if (myValue > 1.0f) {
             pc.printf("Value greater than one, set to one.\n");
            myValue = 1.0f;       
        }
        myPWM.write(myValue);
        pc.printf("%0.2f was read and written to PwmOut D3.\n", myValue);
    }
}