/*
    Project: FanOnOff
    File: main.cpp
    
    Reads from analog input, streams ASCII text to std serial using printf. 
    Controls a fan. Includes setpoint and hysteresis values.
    
    Written by: Dr. C. S. Tritt
    Created: 3/26/17 (as Nightlight)
    Revised: 4/21/21 (v. 1.0)
*/
#include "mbed.h"

const int HIGH = 1; // Optional, but makes code more readable.
const int LOW = 0; // Optional, but makes code more readable.
 
AnalogIn analog_in(A5);
 
DigitalOut fan(D13); // Same as user LED.

int main() {
    float sp = 0.5; // Declare and set setpoint value.
    float hyst = 0.02; // Declare and set hysteresis value.
    float t; // Temperature value read, sent to serial port & used.
    
    printf("\nAnalogIn example\n");
    
    while(true) {
        t = analog_in; // Read the analog input value (0 to 1).
        printf("Temperature (0 to 1) = %f\n", t); // Send out serial port.
        
        if (fan) { // That is, fan == HIGH (1)
            if (t < (sp - hyst)) { // Activate built-in LED. The f is optional.
                fan = LOW;
            }
        } else { 
            if (t > (sp + hyst)) {
                fan = HIGH;
            }
        }
        printf("Fan = %d\n", (int) fan); // Send fan state as serial text.    
        wait(0.25); // 250 ms
    }
}