/*
 Project: Fade
 File: main.cpp
 Last revised by: Dr. C. S. Tritt
 Revision date: 9/13/17 (v. 1.0)
 
 This example shows how to fade an LED on pin D15 using PWM.
 
 This example code is in the public domain.
 */
#include "mbed.h"
// Similar to DigitalOut, you can declare a pin to flicker on and off
// at a desired frequency and duty cycle using PwmOut. 
PwmOut my_LED(D15); // Construct my PwmOut object.

// Create variables to control brightness and fading:
float fadeAmount = 0.05;  
float brightness = 0;

int main()  { 
    while(true) {  
       
        // The LED brightness is set by writing a value between 0.0 and 1.0.
        // This sets the duty cycle (0.5 = 50%, etc.).
        
        my_LED = brightness; // Set brightness.      
        brightness = brightness + fadeAmount;  // Change for next time through.
        
        // Reverse the direction of the fading at the ends of the fade.
        // It's hard for floats to be exactly equal, so reverse if we hit
        // or go past full dark or full bright.
        
        if (brightness <= 0 || brightness >= 1) { // Reverse at limits.
            fadeAmount = -fadeAmount ; // Reverse fade direction.
        }  
        wait(0.03); // Wait for 30 milliseconds to see the dimming effect .
    }
}