
/*
    File: main.cpp
    Project: DivideByZero

    Demonstrates divide by zero on Nucleo boards. For floats, the result is inf, 
    not an error. For ints, the result is 0, not an error. These results are for 
    the default online mbed compiler settings.
    
    Created by Dr. C. S. Tritt; Last revised 10/24/17 (v. 1.1)
*/
#include "mbed.h"

int main()
{
    // Try some float values.
    for (int i = 3; i >= -3; i--) { // Displays inf for 1/0.
        float x = (float) i;
        printf("x is %f and 1/x is %f.\n", x, 1/x);
        wait(0.5f);
    }
    
    // Try some other things with floats.
    float x = 1.0f/0.0f; // Produces compile time warning.
    // The following displays three infs.
    printf("\nx, x+1.0 & 2.0*x are: %f, %f, %f.\n", x, x+1.0f, 2.0f*x);
    printf("\ninf cast to int is %d.\n\n", (int)x);
    
    // Try some int values.
    for (int i = 3; i >= -3; i--) { // Displays 0 for 1/0.
        printf("i is %d and 1/i is %d.\n", i, 1/i);
        wait(0.5f);
    }
    while (true) {}; // Just loop here forever after tests.
}