/*
    Project: CE_Temp_Read
    File: main.cpp
    
    Reads from analog input, streams ASCII text to std serial using printf and
    lights onboard LED.
    
    Written by: Dr. C. S. Tritt
    Created: 3/18/19 (v. 1.1)
*/
#include "mbed.h"

const int SIZE = 20; // Number of samples per average.
const float PAUSE = 0.05; // Seconds between samples.
const float INTERVAL = 1.0; // Seconds between averages.

AnalogIn analog_value(PB_0); // Same as A3
 
DigitalOut led(LED1);

int main() {
    float value; // Value to be sent to serial port: 1 mV = 1 deg. C.
    
    printf("\nCE Dev Board Temperature Read\n");
    led = 0; // Start with LED off.
    
    while(true) {
        int i = 0; // Initialize loop count.
        float sum = 0.0; // Initialize sum.
        while (i < (SIZE - 1)) { // Take SIZE readings and average them.
            value = analog_value.read(); // Get analog value (between 0 and 1).
            sum = sum + value; // Add it to running sum.
            i++; // Increment loop count.
            wait(PAUSE); // Wait PAUSE seconds between samples.
        }
        value = (sum/(float) SIZE); // Calculate average.
        printf("Value = %f\n", value); // Send value as text via serial port.
        led = !led; // Toggle LED.
        wait(INTERVAL); // Wait INTERVAL seconds between averages.
    }
}    