/*
    Project: CE_Temp_Read
    File: main.cpp
    
    Reads from analog input, streams ASCII text to std serial using printf and
    lights onboard LED. Also demonstrates use of floating point literal suffix
    toeliminate warning and int constants for HIGH and LOW.
    
    Written by: Dr. C. S. Tritt
    Created: 3/14/18 (v. 0.9)
    
*/
#include "mbed.h"

const int SIZE = 20;
const float PAUSE = 0.001;
const float INTERVAL = 0.5;

AnalogIn analog_value(PB_0); // Same as A3
 
DigitalOut led(LED1);

int main() {
    float value; // Value to be read and sent to serial port.
    
    printf("\nCE Dev Board Temperature Read\n");
    led = 0;
    
    while(true) {
        int i = 0;
        float sum = 0.0;
        while (i < (SIZE - 1)) {
            value = analog_value.read(); // Read the analog input value (0 to 1).
            sum = sum + value;
            i++;
            wait(PAUSE);
        }
        float aveValue = sum/(float) SIZE;
        printf("Value = %f\n", aveValue); // Send value as text via serial port.
        led = !led;
        wait(INTERVAL);
    }
}