/* 
Project: Button
File: main.cpp
 
Toogles LED1 when USER_BUTTON is pressed. Note LED1 is also PA_5 which is 
also D13.
 
Based on built-in mbed example Nucleo_read_button
Modified 12 Aug 2017 by Sheila Ross
Last revised 9/17/17 by Dr. C. S. Tritt
 
*/
 
#include "mbed.h"
 
// Construct a digital input linked to the USER_BUTTON.
DigitalIn myButton(USER_BUTTON);
 
// Construct a digital output linked to LED1.
DigitalOut myLed(LED1);
 
int main() {
  while(true) { // Main loop.
    if (myButton == 0) { // Button is active low.
      myLed = !myLed; // Toggle LED on/off.
      wait(0.1); // Ignore bounce (if any).
    }
  }
}