/*
  Project: Blink_FET_Variable
  File: main.cpp
  Last revised by: Dr. C. S. Tritt
  Last revision on: 5/7/20 (v. 1.0)
  
  Turns on D4 for 0.7*n second, then off for 0.3*n second, repeatedly. Where n 
  is a scaled pot setting obtained from A1.
 
  This example code is in the public domain.
*/
#include "mbed.h"
// Scale factor (seconds)
double SCALE = 3.0;
// Analog pot reading used to adjust blink interval.
AnalogIn myA_in(A1);
//  Construct a digital output object called myD4 and connect it to D4.
DigitalOut myD_out(D4);
  
int main() {   // This curly brace marks the beginning of the main function.
    // Loop forever. 
    while(true) {   // This curly brace marks the start of the repeated actions.
        double n = SCALE*myA_in;
        myD_out = 1;   // Turn on D4 by "storing" a 1 in it.
        wait(0.7*n);  // wait(x) will pause for a given number of seconds.
        myD_out = 0;   // Turn off D4 by "storing" a 0 in it.
        wait(0.3*n);  // Wait another 0.3 seconds.
    }  // end of repeated actions. 
}  // end of main function.