/*
  Project: Blink_FET
  File: main.cpp
  Last revised by: Dr. C. S. Tritt
  Last revision on: 4/8/19 (v. 1.0)
  
  Turns on D4 for 0.7 second, then off for 0.3 second, repeatedly.
 
  This example code is in the public domain.
*/
#include "mbed.h"
//  Construct a digital output object called myD4 and connect it to D4.
DigitalOut myD4(D4);
  
int main() {   // This curly brace marks the beginning of the main function.
    // Loop forever. 
    while(true) {   // This curly brace marks the start of the repeated actions.
        myD4 = 1;   // Turn on D4 by "storing" a 1 in it.
        wait(0.7);  // wait(x) will pause for a given number of seconds.
        myD4 = 0;   // Turn off D4 by "storing" a 0 in it.
        wait(0.3);  // Wait another 0.3 seconds.
    }  // end of repeated actions. 
}  // end of main function.