/*
    Project: AtoDSpeed
    File: main.cpp

    Determines and diplays speed of A to D conversion. See notebook
    documentation.

    Written by: Dr. C. S. Tritt
    Created: 9/24/17 (v. 1.0)

*/
#include "mbed.h"

Serial pc(USBTX, NC, 9600); // Serial transmit only @ 9600 baud.
Timer myTimer; // Timer to time read times.
AnalogIn vSource(A0); // Construct AnalogIn object called analog_value.

int main()
{
    printf("\nA to D Speed Test (v. 1.0)\n"); // Identify program.

    const int SIZE = 20; // Number of array elements.
    int viReading[SIZE]; // Integer array for readings.
    float vfReading[SIZE]; // Float array for readings.
    
    myTimer.reset(); myTimer.start(); // Reset & start the time.
    for (int i = 0; i <= SIZE - 1; i++) {
        viReading[i] = vSource.read_u16();
    }
    printf("It took %i uS to read...\n", myTimer.read_us());
    
    myTimer.reset(); myTimer.start(); // Reset & start the time.    
    for (int i = 0; i <= SIZE - 1; i++) {
        printf("V[%i] = %i counts\n", i, viReading[i]);
    }
    printf("It took %i uS to send the results.\n", myTimer.read_us());
    
    myTimer.reset(); myTimer.start(); // Reset & start the time.
    for (int i = 0; i <= SIZE - 1; i++) {
        vfReading[i] = vSource.read();
    }
    printf("It took %i uS to read...\n", myTimer.read_us());
    
    myTimer.reset(); myTimer.start(); // Reset & start the time.    
    for (int i = 0; i <= SIZE - 1; i++) {
        printf("V[%i] = %f counts\n", i, vfReading[i]);
    }
    printf("It took %i uS to send the results.\n", myTimer.read_us());} 