/*
    Project: ArraySizeof
    File: main.cpp
    Ported to mbed/Nucleo by: Dr. C. S. Tritt
    Last revised: 10/22/17 (v. 1.1)

    Demonstrates array output.

*/
#include "mbed.h"

int main(void)
{
    // Create a 2-D array.
    int myNum[3][4] = {
        { 10, 20, 30, 40 }, // Values for first row
        { 15, 25, 35, 45 }, // Values for second row
        { 47, 48, 49, 50 }  // Values for third row
    };
    
    printf("\n\nArray output...\n\n");
    // Known sizes.
    for (int r = 0; r < 3; r++) {
        for (int c = 0; c < 4; c++) {
            printf("%d   ", myNum[r][c]);
        }
        printf("\n");
    }
    
    // For mbed/Nucleo boards, the final \n is generally required to see output.
    printf("\nElement size (sizeof(myNum[0][0]): %u.\n", sizeof(myNum[0][0]));
    printf("Row size (sizeof(myNum[0]): %u.\n", sizeof(myNum[0])); // Row size.
    printf("Array size (sizeof(myNum): %u.\n\n", sizeof(myNum)); // Total size.
    
    // Output using calculated sizes.
    for (int r = 0; r < sizeof(myNum)/sizeof(myNum[0]); r++) {
        for (int c = 0; c < sizeof(myNum[0])/sizeof(myNum[0][0]); c++) {
            printf("%d   ", myNum[r][c]);
        }
        printf("\n");
    }
    
    while (true) {} // Loop forever when done.
}