/*
    Project: ArrayPointers
    File: main.cpp
    Modified by: Dr. C. S. Tritt
    Last revised: 11/5/17 (v. 1.0)

    Based on Horton Program 7.4 Arrays and pointers.
*/
#include "mbed.h"

//
int main(void)
{
    char myString[] = "My text."; // Initialize a string.
    printf("\nString content (direct): %s\n", myString);

    char* p = &myString[0]; // Take the address of the 1st element.
    printf("String content (explicit reference): %s\n", p);

    p = myString; // A plain array name is a pointer to its 1st element.
    printf("String content (implied reference: %s\n", p);

    // Here's another way to initialize a string. This is actually the 
    // approach recommended by Kieras at Michigan as it may avoid the creation 
    // and storage of a literal followed by copying to the array...
    char* pMyOtherString = "Here is more text.";
    printf("Other string: %s\n", pMyOtherString);
    
    printf("Done. I sleep now.\n");
    while(true) wait(3600.0f);
}