/*
  Project: 21_mySwitch_v5
  File: main.cpp
  Last revised by: Dr. C. S. Tritt
  Last revised on: 9/29/21 (v. 1.3)
 
 Demonstrates the use of a switch statement. The switch statement allows you 
 to choose from among a set of discrete values of a variable. It's like a 
 series of if statements.
 
 To see this program (sketch) in action, but the board and sensor in a well-lit 
 room, open a serial monitor, and and move your hand gradually down over the 
 sensor.
 
 The circuits:
 
 * A 10 kohm pot between + 3.3 V and ground with the wiper connected to A0.
 --or--
 * Photoresistor from A0 to +3.3 V in and a 10 kohm resistor from A0 to ground.
  
 Created 1 Jul 2009; modified 9 Apr 2012 by Tom Igoe 
 Modified for Nucleo / mbed 12 Aug 2017 by Sheila Ross
 Futher modified by Dr. C. S. Tritt 2017 and 2021.
 
 This example code is in the public domain.
 
 http://www.arduino.cc/en/Tutorial/SwitchCase
 */

#include "mbed.h"

// Define sample interval (1/rate) and baud rate.
const int SAMPLE = 400; // mS
const int BAUD = 9600;

// Define the analog input we are using for the sensor.
AnalogIn sensorVoltage(A0);

// Create an output only serial connection over our USB.
Serial pc(USBTX, NC, BAUD); // Set pins and speed, NC is no connection.

int main() {
 
    while(true) {
        // Read the analog sensor. Rescale the reading to obtain a number 
        // between 0 and 3.999 which will be stored as 0 through 3 in the 
        // integer range.
        int range = sensorVoltage*4;

        // Produce differnt output depending on the range value. Switching the 
        // following construct from a switch to an if-else would provide more 
        // flexibility in the specification of the catagory ranges.
        switch (range) {   // Note no braces between cases.
            case 0:    // Sensor covered.
                // Cast to float required! Note a second conversion is done to
                // produce output. This can lead to unexpected results and 
                // "wastes" some processor time.
                pc.printf("Dark: %f\n", static_cast<float>(sensorVoltage));
                break;
            case 1:    // Sensor in dim light. 
                pc.printf("Dim: %f\n", static_cast<float>(sensorVoltage));
                break;
            case 2:    // Sensor in medium light.
                pc.printf("Medium: %f\n", static_cast<float>(sensorVoltage));
                break;
            case 3:    // Bright light shining on sensor.
                pc.printf("Bright: %f\n", static_cast<float>(sensorVoltage));
                break;     
            default:   // Error situation. Should never happen.
                pc.printf("Error!\n");
        }
        ThisThread::sleep_for(SAMPLE); // Value in mS.
    }
}