/*
Project: 21_WhatTime_v5
File: main.cpp
 
Uses a timer to display the interval between button press and release.
 
Created 12 Aug 2017 by Dr. Sheila Ross.
Last modified 9/30/21 by C. S. Tritt (v. 1.0)
*/
#include "mbed.h"
 
// Construct a USER_BUTTON digital input.
DigitalIn myButton(USER_BUTTON);
// Construct a timer object.
Timer myTimer;
// Construct a transmit only serial connection over our USB.
Serial pc(USBTX, NC, 9600);

int main()
{
    myTimer.start();  // Start the timer.
    while(true) { // Main loop.
        if (myButton == 0) { // Button is pressed (its active low).
            // Save the current timer value (state). uSs since reset.
            float current_time = myTimer.read();            
            // Send the time as text via the serial port.
            pc.printf("Time difference %f seconds.\n",current_time );         
            myTimer.reset(); // Reset the timer.            
            while(myButton == 0) {} // Empty loop. Wait for button release.
        }
    }
}