/*
Project: 21_TimerTest1_v5
File: main.cpp
 
Explores timer behavior. Each loop takes about 24 mS. Most of this time is 
likely spent doing the serial output.
 
Last modified 9/30/21 by C. S. Tritt (v. 1.0)
*/
#include "mbed.h"

// Construct a timer object.
Timer myTimer;
// Construct a transmit only serial connection over our USB.
Serial pc(USBTX, NC, 9600);
 
int main()
{
    myTimer.start();  // Start the timer.
 
    for (int i = 1; i <= 20; i++) { // Main loop.
        // Save the time on timer.
        float current_time = myTimer.read();   
        // Send the time as text via the serial port.
        pc.printf("Time %f seconds.\n",current_time );
    }
}