/*
    Project: 21_TW_Ex_9_1_v5
    File: main.cpp
    
    An example similar to T&W example 9.1. Green junction will flash 
    continuously. Blue junction will toggle in response to depressing the user 
    button.
    
    Circuit (common cathode RGB LED needed)
    
    Connect green junction anode to D3.
    Connect blue junction anode to D4.
    Connect common cathode to common (ground).
    
        Created by Dr. C. S. Tritt
    Last revised: 10/17/21 (v. 1.0)
*/
#include "mbed.h"

InterruptIn myButton(USER_BUTTON); // Button is normally high. Goes low w/press.

DigitalOut bluLED(D4); // Blue and green LED junctions.
DigitalOut grnLED(D3);

void myISR() { // Simple ISR toggles the blue LED junction when called.
    bluLED = !bluLED; // Toggle blue junction.
}

int main() {
    const int GRN_PERIOD = 500;
    bluLED = 0; // Turn blue & green off at start.
    grnLED = 0; 
    
    myButton.fall(&myISR); // "Register" the ISR routine. Sets vector.
    
    while(true) {
        grnLED = !grnLED; // Toggle green junction.
        ThisThread::sleep_for(GRN_PERIOD); // Sleep for GRN_PERIOD mS.
    }
}