/*
    Project: 21_Speaker_v5
    File: main.cpp

    Use PWM to sound speaker audio alarm.

    Written by: Dr. C. S. Tritt
    Created: 10/27/21 (v. 1.0)
*/
#include "mbed.h"

DigitalIn uB(USER_BUTTON); // The user button input (normally high).
PwmOut spkrOut(D12); // The speaker output.

const int SLP_TIME = 100; // 0.1 s sample interval.
// PWM period: 2500 uS = 2.5 mS --> 400 Hz.
const int PWM_PRD = 2500; 
const float DUTY_CYCLE = 0.5f; // Duty cycle as a fraction.
int main(void)
{
    // Setup.
    spkrOut.period_us(PWM_PRD);
    // Enter main loop.
    while(true) {
        if (uB) {
            spkrOut.write(0); // No sound.
        } else {
            spkrOut.write(DUTY_CYCLE); // Set duty cycle to sound speaker.            
        }
        ThisThread::sleep_for(SLP_TIME);  // Display value for 0.1 seconds.            
    }
}