/*
Project: 21_SerialPass_v5
File: main.cpp

This project demonstrates how to pass a Serial object to functions by reference. 
It also introduces multi-file projects and C strings. It uses VT-100 escape 
sequences to prevent scrolling and change text color.

The function approach to sending terminal control commands is awkward. It was 
used to demonstrate the use of multiple functions each in their own file and 
custom header files. The string constant approach used after the button is 
better. It involves defining char array constants containing the escape codes. 
The \x1B inserts the 1B_16 (escape) characters into the char vectors (really 
"C strings" because they are "null terminated" (since they were created using 
double quotes). Use the strings in printf statements to send the control text 
to the terminal. There are probably even betters ways to do this, but this is 
good enough for now.
 
See...

* C Strings: https://www.tutorialspoint.com/cprogramming/c_strings.htm.
* String literal escape sequences (this is a different meaning than the VT-100
  terminal escape sequences): https://en.cppreference.com/w/cpp/language/escape.
* VT-100 Escape sequences:  http://www.csie.ntu.edu.tw/~r92094/c++/VT100.html
* ANSI Escape Sequences:
  https://gist.github.com/fnky/458719343aabd01cfb17a3a4f7296797.
* ANSI Color Codes, etc.
  https://www.lihaoyi.com/post/BuildyourownCommandLinewithANSIescapecodes.html.

Calls

clrTerm - Clears terminal and places cursor at home position.
whiteText - Makes text white. Ackward to use. Done for demo.
blueText - Makes text blue. Awkward to use. Done for demo.

Written by: Dr. C. S. Tritt; Last revised 10/17/21 (v. 1.0)
*/
#include "mbed.h"
#include "myFuncs.h"

// Construct a USER_BUTTON digital input.
DigitalIn myButton(USER_BUTTON);
// Construct a Serial object for output only.
Serial pc(USBTX, NC, 9600);

int main()
{
    clrTerm(pc); // Clear the terminal at startup.
    whiteText(pc); // Change text to white (likely the default).
    pc.printf("Welcome to SerialPass.\n");
    // This is awkward but demonstrates the use of multiple function files.
    pc.printf("Press the ");
    blueText(pc); // Change text to blue. There are better approaches to this.
    pc.printf("blue User Button");
    whiteText(pc); // Change text to white.
    pc.printf(" to clear this and continue...\n");
    
    // Wait here for button to be pressed (making it low, false).
    while (myButton) {
        ThisThread::sleep_for(10); // Yield some time to other threads.
    }
    // Display the most button text.
    clrTerm(pc); // Clear the terminal.
    const char red[] = "\x1B[31m";
    const char white[] = "\x1B[37m";
    const char blue[] = "\x1B[34m";     
    pc.printf("The screen should clear and this text appear in...\n");
    // Note finish with white to leave terminal in the expected state.
    pc.printf("%sred, %swhite, and %sblue%s.\n", red, white, blue, white);
    while(true) {  // Main forever loop.
        ThisThread::sleep_for(300000); // Sleep for 5 minutes, repeatedly.
    }
}