/* File: clrTerm.cpp

This function uses ANSI/VT100 escapse sequences to clear the terminal. Serial
object must be passed by reference (since it is physically unique and can't be
copied). The call will look normal (clrTerm(pc)) as does the usage of pc here.

Created by Dr. C. S. Tritt
Last revised: 10/16/21 (v. 1.0)
*/

// Need for mbed use.
#include "mbed.h"

// Including the myFuncs.h header here will catch mismatches between the 
// declaration and the definition.
#include "myFuncs.h"

void clrTerm(Serial & pc){
    const char ESC = 27; // Define escape character for escape sequence.
    pc.printf("%c[2J%c[H", ESC, ESC); // ANSI/VT100 clear screen/home.
}