/*
Project: 21_ScopeEx2_v5
File: main.cpp

 This simple program demonstrates that C passes arguments by value.

 Uses VT-100 escape sequences to prevent scrolling. See
 http://www.csie.ntu.edu.tw/~r92094/c++/VT100.html and/or
 https://gist.github.com/fnky/458719343aabd01cfb17a3a4f7296797.

 Written by: Dr. C. S. Tritt; Last revised 10/11/21 (v. 1.1)
*/
#include "mbed.h"

int main()
{
    const int DELAY = 2000000;; // mS wait time.
    const char ESC = 27; // Define escape character for escape sequence.
    printf("%c[2J%c[H", ESC, ESC); // ANSI/VT100 clear screen/home.

    int count = 0; // Declared in outer block.
    do {
        int count = 0; // This is another variable called count.
        ++count; // this applies to inner count.
        printf("count = %d\n", count);
    } while( ++count <= 5); // This works with outer count.

    printf("count = %d\n", count); // Inner count is dead.

    while(true) {  // Main forever loop.
        ThisThread::sleep_for(DELAY); // Pause
    }
}