/*
Project: 21_ScopeEx1_v5
File: main.cpp

 This simple program demonstrates that C passes arguments by value.

 Uses VT-100 escape sequences to prevent scrolling. See
 http://www.csie.ntu.edu.tw/~r92094/c++/VT100.html and/or
 https://gist.github.com/fnky/458719343aabd01cfb17a3a4f7296797.

 Written by: Dr. C. S. Tritt; Last revised 10/11/21 (v. 1.1)
*/
#include "mbed.h"

int main()
{
    const int DELAY = 2000000;; // mS wait time.
    const char ESC = 27; // Define escape character for escape sequence.
    printf("%c[2J%c[H", ESC, ESC); // ANSI/VT100 clear screen/home.

    int count1 = 1; // Declared in outer block

    do { // Do while construct may be new to you!
        int count2 = 0; // Declared & initialized in inner block
        ++count2; // Ineffective due to line above!
        printf("count1 = %d count2 = %d\n", count1, count2);
    // Note that count1 is incremented in while test! 
    } while (++count1 <= 5);  // count2 no longer exists after loop exit.

    printf("count1 = %d\n", count1);
    return 0;

    while(true) {  // Main forever loop.
        ThisThread::sleep_for(DELAY); // Pause
    }
}