/*
Project: 21_GlobalEx_v5
File: main.cpp

 This simple program demonstrates that C passes arguments by value.
 
 Uses VT-100 escape sequences to prevent scrolling. See 
 http://www.csie.ntu.edu.tw/~r92094/c++/VT100.html and/or 
 https://gist.github.com/fnky/458719343aabd01cfb17a3a4f7296797.
 
 Written by: Dr. C. S. Tritt; Last revised 10/11/21 (v. 1.1)
*/
#include "mbed.h"

int myFunc(int x, int y); // Function declaration required.

// Arbitrary factor. Unitless. Move into main to break project.
const float myFactor = 3.3f; // Suffix f indicates float (default is double).

int main() {
    const int DELAY = 2000;; // mS wait time.
    const char ESC=27; // Define escape character for escape sequence.
    while(true) { // Main forever loop.
        printf("%c[2J%c[H", ESC, ESC); // ANSI/VT100 clear screen/home.
        printf("In function demo main...\n");        
        int a = 5; // Create and initialize a.
        printf("a = %d\n", a); // Display a.
        int b = 6; // Create and initialize b.
        printf("b = %d\n", b); // Display b.
        printf("About to call my function.\n");
        int c = myFunc(a, b); // Call my function.
        printf("Function has returned.\n");
        printf("c = %d\n", c); // Display b.
        ThisThread::sleep_for(DELAY); // Pause
    }
}

int myFunc(int x, int y) { // Function definition. Often in separate files!
    int z = (x + y)/myFactor;
    return z; // Explicit return is required in C/C++. 
}