/*
  Project: 21_ForShift_v5
  File: main.cpp
 
 Demonstrates the use of a for() loop. Lights indivdiual LEDs of a bargraph
 display in sequence, then in reverse order. Note this version still has a 
 minor glitch when the bar is at the left end of the display.  
 
 The circuit:
 
    Bargraph LEDs from pins D2 through D11 to ground via 330 Ohm resistors.
 
 Created 2006  by David A. Mellis
 Modified 2011  by Tom Igoe
 Modified for Nucleo / mbed 12 Aug 2017  by Sheila Ross
 Modified by C. S. Tritt 9/21/17 and 10/10/21 (v. 1.1, untested)
 
This example code is in the public domain.
*/
 
#include "mbed.h"
 
const int DELAY = 100;; // mS wait time.
 
BusOut bar_graph(D2,D3,D4,D5,D6,D7,D8,D9,D10,D11);
 
int main() {
  
    while(true) { // Keep the lights going back and forth forever.
 
        // Lighted bar will shift from 0 to 9 places.
        for(int shift = 0; shift < 10; shift++) {
            bar_graph = (1 << shift); // A 1 shifted over "shift" places.
            ThisThread::sleep_for(DELAY); // Pause
        }
 
        // Now shift down from 9 to 0 places.
        for(int shift = 9; shift >= 0; shift--) {
            bar_graph = (1 << shift); // A 1 shifted over "shift" places.
            ThisThread::sleep_for(DELAY); // Pause
        }
    }
}