/*
  Project: 21_ShiftFor2_v5
  File: main.cpp

 Demonstrates the use of a for() loop. Lights indivdiual LEDs of a bargraph
 display in sequence, then in reverse order. This version demonstrates the use
 of the combination assignment operators. In general it is probably better to 
 use the shift operators. This is the "Nightrider" effect.
 
 This version has a minor glitch (blink) when bar is at left end of bar.

 The circuit:

    Bargraph LEDs from pins D3 through D12 to ground via 330 Ohm resistors.

 Created 2006  by David A. Mellis
 Modified 2011  by Tom Igoe
 Modified for Nucleo / mbed 12 Aug 2017  by Sheila Ross
 Modified by C. S. Tritt 9/21/17 and 10/10/21 (v. 1.1)

This example code is in the public domain.
*/

#include "mbed.h"

const int DELAY = 100;; // mS wait time.

BusOut bar_graph(D2,D3,D4,D5,D6,D7,D8,D9,D10,D11);

int main()
{

    while(true) { // Keep the lights going back and forth forever.

        int barLoc = 1; // Set inital bar location (value).
        // Lighted bar will shift from 0 to 9 places.
        for(int shift = 0; shift < 10; shift++) {
            barLoc *= 2; // Shift one bar left.
            bar_graph = barLoc; // Update display.
            ThisThread::sleep_for(DELAY); // Pause
        }

        // Now shift down from 9 to 0 places.
        for(int shift = 9; shift >= 0; shift--) {
            barLoc /= 2; // Shift one bar rightt.
            bar_graph = barLoc; // Update display.
            ThisThread::sleep_for(DELAY); // Pause
        }
    }
}