/*
Project: 21_ConsoleIO_v5
File: main.cpp

 This simple program demonstrates that C passes arguments by value.

 Uses VT-100 escape sequences to prevent scrolling. See
 http://www.csie.ntu.edu.tw/~r92094/c++/VT100.html and/or
 https://gist.github.com/fnky/458719343aabd01cfb17a3a4f7296797.

 Written by: Dr. C. S. Tritt; Last revised 10/11/21 (v. 1.1)
*/
#include "mbed.h"

Serial pc(USBTX, NC, 9600);

int main()
{
    const int DELAY = 2000000;; // mS wait time.
    const char ESC = 27; // Define escape character for escape sequence.
    pc.printf("%c[2J%c[H", ESC, ESC); // ANSI/VT100 clear screen/home.

    // Replace the code below with your code.
    int count = 1; // Do while loop counter.
    int iCount = 0; // Counter in do-while loop.
    do {
        --iCount; // this applies to inner count.
        printf("Count Down = %d and abs(Count Down) = %d\n", 
            iCount, abs(iCount));
    } while( ++count <= 5); // This works with outer count.

    pc.printf("count = %d\n", count);

    while(true) {  // Main forever loop.
        ThisThread::sleep_for(DELAY); // Pause
    }
}