/*
Project: 21_Button_v5 (Button/LED Demo)
File: main.cpp

Toogles LED1 when USER_BUTTON is tapped. Note LED1 is also PA_5 which is
also D13. Based on built-in mbed example Nucleo_read_button. Holding the button 
down will result in LED flashing.

Modified 12 Aug 2017 by Dr. Sheila Ross
Last revised 10/5/21 by Dr. C. S. Tritt (v. 1.0)
*/

#include "mbed.h"

// Construct a digital input linked to the USER_BUTTON.
DigitalIn myButton(USER_BUTTON); // Built in blue button.

// Construct a digital output linked to LED1.
DigitalOut myLed(LED1); // Built-in green LED.

int main()
{
    while(true) { // Main loop.
        if (myButton == 0) { // Button is active low.
            myLed = !myLed; // Toggle LED on/off.
            ThisThread::sleep_for(100);  // Avoid double-tap, 0.1 seconds.
        }
    }
}