/*
Project: 21_ButtonImproved_v5 (Button/LED Demo)
File: main.cpp

Turns LED1 on when USER_BUTTON is held down. Otherwise LED1 is off.

Modified 12 Aug 2017 by Dr. Sheila Ross
Last revised 10/5/21 by Dr. C. S. Tritt (v. 1.0)
*/

#include "mbed.h"

// Construct a digital input linked to the USER_BUTTON.
DigitalIn myButton(USER_BUTTON); // Built in blue button.

// Construct a digital output linked to LED1.
DigitalOut myLed(LED1); // Built-in green LED.

int main()
{
    myLed = 0; // Start with LED off (the default)
    while(true) { // Main loop.
        if (!myButton) { // Button is active low.
            myLed = 1; // Turn LED on.
            while (!myButton);  // Wait here for button release.
            myLed = 0; // Turn LED back off.
        }
    }
}