/*
Project: 21_BitTests_v5
File: main.cpp
 
This program is intended for use exploring bitwise operator. It also 
demonstrates the use of the 8-bit unsigned char type and using printf to 
display integer values in various number bases.
 
Last modified 9/30/21 by C. S. Tritt (v. 1.0)
*/
#include "mbed.h"

// Pulse durations.
const int SPULSE = 500;
const int LPULSE = 1000;

// Construct a transmit only serial connection over our USB.
Serial pc(USBTX, NC, 9600); // Serial channel to PC.
// Construct a 8-bit BusOut bargraph display.
BusOut barGraph(D2, D3, D4, D5, D6, D7, D8, D9);  // The display.
 
int main()
{
    while (true) { // Main loop.
        // Set some values.
        unsigned char myIntA = 0b10101010; // Binary. 170_10.
        unsigned char myIntB = 0x3E; // Hex. 62_10.
        unsigned char myIntC = 077; // Octal, 63_10.
        
        // Do a bitwise operation.
        unsigned char myIntD = myIntA | myIntB;
          
        // Send output to PC and bargraph.
        pc.printf("myIntA = %d (base 10).\n", myIntA);
        barGraph = myIntA;
        ThisThread::sleep_for(SPULSE);
    
        pc.printf("myIntB = %X (Hexadecimal).\n", myIntB);
        barGraph = myIntB;
        ThisThread::sleep_for(SPULSE);
    
        pc.printf("myIntC = %o (Octal).\n", myIntC);
        barGraph = myIntC;
        ThisThread::sleep_for(SPULSE);
    
        pc.printf("myIntD = %X (Hexadecimal).\n", myIntD);
        barGraph = myIntD;
        ThisThread::sleep_for(LPULSE);
        pc.printf("Repeating...\n\n");
    }
}