/*
    Project: BinaryCount
    File: main.cpp
    
    Displays 8 bit binary count on bar graph display.
    
    Written by: Dr. C. S. Tritt
    Created: 9/20/21 (v. 1.2)
*/
#include "mbed.h"

BusOut barGraph(D2, D3, D4, D5, D6, D7, D8, D9);  // Create BusOut object.

int main() {
    // Test the wiring.
    barGraph = 0;  // All bars off (base 10).
    ThisThread::sleep_for(400); // For 0.4 seconds.
    barGraph = 0b01010101;  // Odd bars on (binary).
    ThisThread::sleep_for(400); // Test even bars for 0.4 seconds. 
    barGraph = 0b10101010;  // Even bars on (binary).   
    ThisThread::sleep_for(400); // Test even bars for 0.4 seconds.
    barGraph = 0xFF;  // All bars on. Hex.
    ThisThread::sleep_for(400); // For 0.4 seconds.
    // Enter main loop.   
    while(true) {
        for (int i = 0; i < 256; i++) { // Add one to count.
            barGraph = i;  // Copy the count to the bargraph.
            ThisThread::sleep_for(100);  // Display the value for 0.1 seconds.
        }
    }
}