/*
    Project: 21_BC_Improved_v5 (Improved Binary Counter (while loop) Version)
    File: main.cpp
    
    Displays 8-bit binary count on bar graph display. This version uses a while 
    loop which provides a much better starting point for an Up/Down counter.
    
    Error in pow function use corrected in v. 1.0.
    
    Note: I tried to use count for the loop counter but this resulted in an 
    ambiguous name error.
        
    Written by: Dr. C. S. Tritt
    Created: 10/5/21 (v. 1.1)
*/
#include "mbed.h"

DigitalIn uB(USER_BUTTON); // Button is active low (up = 1, down = 0).
const int bits = 8; // Number of bits to use.
const int c_max = pow(2, bits) - 1; // Maximum count. pow is type double.
const int sleepTime = 100; // Sleep time in milliseconds.
int myCount = 0; // Count to be displayed. Loop counter.
BusOut barGraph(D2, D3, D4, D5, D6, D7, D8, D9);  // The display.

int main() {
    // Test the wiring.
    ThisThread::sleep_for(400); // For 0.4 seconds.
    barGraph = 0b01010101;  // Odd bars on (binary).
    ThisThread::sleep_for(400); // Test even bars for 0.4 seconds. 
    barGraph = 0b10101010;  // Even bars on (binary).   
    ThisThread::sleep_for(400); // Test even bars for 0.4 seconds.
    barGraph = 0xFF;  // All bars on. Hex.
    ThisThread::sleep_for(400); // For 0.4 seconds.  

    barGraph = myCount; // Initialize the display to myCount.
    // Enter main loop. 
    while(true) {
        while (myCount >= 0 && myCount <= c_max) {
            barGraph = myCount; // Set display to myCount.
            ThisThread::sleep_for(sleepTime);  // Display value for 0.1 seconds.
            myCount++;
        }
        myCount = 0;
    }
}