/*
    Project: 21_7segmentTest_v5 (Lab Wk 10)
    File: main.cpp
    
    This test program confirms hardware operation and demonstrates use of the 
    7-segement display. It will also be used as the starting point for the 
    Week 10 lab practical.

    Display "value" from 0 to F_16 to DP (16_10) to all off (17_10) to all on 
    (17_10) on 7-segment display.
    
    Note: This display function takes an integer argument to be display and a 
    BusOut object (passed by reference) on which to display it as arguments.
    This differs from the Week 8 Lab display function.
    
    Written by: Dr. C. S. Tritt
    Created: 11/9/21 (v. 1.0)
*/
#include "mbed.h"

void display(int disVal, BusOut &disBus);

Serial pc(USBTX, NC, 9600); // Use for debugging.

const int SLP_TIME = 1000; // Update once per second.

int main(void)
{
    // Note that bit sequence is the oposite of what I initially thought they 
    // would be. That is, pins are listed in low order to high order sequence.
    BusOut disBus(D9, D8, D7, D6, D5, D4, D3, D2); // The display.
    int myCount = 0; // Loop count. Rolls over at 18.
    
    // Test the wiring.
    display(18, disBus);  // All on (binary).
    ThisThread::sleep_for(2000); // Test even bars for 0.4 seconds.
    display(17, disBus);  // All off (binary).
    ThisThread::sleep_for(2000); // Test even bars for 0.4 seconds.
    
    // Enter main loop.
    while(true) {
        display(myCount, disBus); // Display myCount (count).
        pc.printf("In main myCount = %d.\n", myCount); // Send count to PC.
        myCount++; // Increment the count.
        if (myCount > 18) myCount = 0; // Rollover!
        ThisThread::sleep_for(SLP_TIME);  // Display value for 1 second.
    }
}

void display(int disVal, BusOut &disBus){
    // 7-segment, active low look-up-table. Displays Hex 0 to F, dp, all off 
    // and all on. 
    const int lutAL[] = { 
    0b00000011, // 0 = 0
    0b10011111, // 1 = 1
    0b00100101, // 2 = 2
    0b00001101, // 3 = 3
    0b10011001, // 4 = 4
    0b01001001, // 5 = 5
    0b01000001, // 6 = 6
    0b00011111, // 7 = 7
    0b00000001, // 8 = 8
    0b00001001, // 9 = 9
    0b00010001, // 10 = a
    0b11000001, // 11 = b
    0b11100101, // 12 = c
    0b10000101, // 13 = d
    0b01100001, // 14 = e
    0b01110001, // 15 = f
    0b11111110, // 16 = dp
    0b11111111, // 17 = All off
    0b00000000  // 18 = All on
    //abcdefg_dp – 7-segement output codes 0 to 18.
    };
    disBus = lutAL[disVal];
    pc.printf("In display, disVal = %d\n", disVal);
}