/*
    Project: 21_7segmentTest3_v5 (Lab Wk 10)
    File: display.cpp (v. 1.0)
    
    Display "value" from 0 to F_16, DP (16_10), all off (17_10), and all on
    (18_10) on 7-segment display.

    Note: This display function requires an integer argument to be display, a 
    BusOut object(passed by reference)on which to display the value of it's 
    first argument, and a Serial object to which to send debugging output. This 
    differs from the similar Week 8 Lab display function that depended upon 
    global variables. The approached used here is more robust.
    
    Written by: Dr. C. S. Tritt
    Created: 11/10/21 (v. 1.0)
*/
#include "display.h"

void display(int disVal, BusOut &disBus, Serial &pc){
    // 7-segment, active low look-up-table. Displays Hex 0 to F, dp, all off 
    // and all on. 
    const int lutAL[] = { 
        0b00000011, // 0 = 0
        0b10011111, // 1 = 1
        0b00100101, // 2 = 2
        0b00001101, // 3 = 3
        0b10011001, // 4 = 4
        0b01001001, // 5 = 5
        0b01000001, // 6 = 6
        0b00011111, // 7 = 7
        0b00000001, // 8 = 8
        0b00001001, // 9 = 9
        0b00010001, // 10 = a
        0b11000001, // 11 = b
        0b11100101, // 12 = c
        0b10000101, // 13 = d
        0b01100001, // 14 = e
        0b01110001, // 15 = f
        0b11111110, // 16 = dp
        0b11111111, // 17 = All off
        0b00000000  // 18 = All on
        //abcdefgp – 7-segement output codes 0 to 18, p is decimal point.
    };
    pc.printf("In display disVal = %d.\n", disVal); // Send display value.
    disBus = lutAL[disVal];
}