/*
    Project: 21_7segmentTest3_v5 (Lab Wk 10)
    File: main.cpp (v. 1.0)

    This test program confirms hardware operation and demonstrates use of the
    7-segement display. This version is the the solution to both modification 
    parts in the 2021 week 10 lab practical.

    Written by: Dr. C. S. Tritt
    Created: 11/10/21 (v. 1.0)
*/
#include "mbed.h"
#include "display.h"

const int SLP_TIME = 1000; // Update once per second.

int main(void)
{
    Serial pc(USBTX, NC, 9600); // Use for development & debugging.
    // Note that bit sequence is the oposite of what I initially thought they
    // would be. That is, pins are listed in low order to high order sequence.
    BusOut disBus(D9, D8, D7, D6, D5, D4, D3, D2); // The display.
    // Construct a digital input linked to the USER_BUTTON.
    DigitalIn myButton(USER_BUTTON); // Built in blue button.
    int myCount = 0; // Loop count. Rolls over at 18.

    // Test the wiring.
    display(18, disBus, pc);  // All on (binary).
    pc.printf("In wiring test = %d.\n", myCount); // Send count to PC.
    ThisThread::sleep_for(2000); // Test even bars for 2.0 seconds.
    display(17, disBus, pc);  // All off (binary).
    pc.printf("In wiring test = %d.\n", myCount); // Send count to PC.
    ThisThread::sleep_for(2000); // Test even bars for 2.0 seconds.

    // Enter main loop.
    while(true) {
        display(myCount, disBus, pc); // Display myCount (count).
        pc.printf("In main myCount = %d.\n", myCount); // Send count to PC.
        // Count up when button is up. Count down when button is down.
        if (myButton) {
            myCount++; // Increment the count.
            if (myCount > 15) myCount = 0; // Rollover!
        } else {
            myCount--; // Increment the count.
            if (myCount< 0) myCount = 15; // Rollunder!
        }
        ThisThread::sleep_for(SLP_TIME);  // Display value for 1 second.
    }
}