#include "display.h"

void display(int disVal, BusOut &disBus){
    // 7-segment, active low look-up-table. Displays Hex 0 to F, dp, all off 
    // and all on. 
    const int lutAL[] = { 
    0b00000011, // 0 = 0
    0b10011111, // 1 = 1
    0b00100101, // 2 = 2
    0b00001101, // 3 = 3
    0b10011001, // 4 = 4
    0b01001001, // 5 = 5
    0b01000001, // 6 = 6
    0b00011111, // 7 = 7
    0b00000001, // 8 = 8
    0b00001001, // 9 = 9
    0b00010001, // 10 = a
    0b11000001, // 11 = b
    0b11100101, // 12 = c
    0b10000101, // 13 = d
    0b01100001, // 14 = e
    0b01110001, // 15 = f
    0b11111110, // 16 = dp
    0b11111111, // 17 = All off
    0b00000000  // 18 = All on
    //abcdefg_dp – 7-segement output codes 0 to 18.
    };
    disBus = lutAL[disVal];
}