/*
    Project: 21_7segmentTest2_v5 (Lab Wk 10)
    File: main.cpp (v. 1.0)
    
    This is a modified, multi-file version of my original 7-segment display 
    test program.
    
    This test program confirms hardware operation and demonstrates use of the 
    7-segement display. It will also be used as the starting point for the 
    Week 10 lab practical.

    Display "value" from 0 to F_16 to DP (16_10) to all off (17_10) to all on 
    (17_10) on 7-segment display.
    
    Note: This display function takes an integer argument to be display and a 
    BusOut object (passed by reference) on which to display it as arguments.
    This differs from the Week 8 Lab display function.
    
    Written by: Dr. C. S. Tritt
    Created: 11/9/21 (v. 1.0)
*/
#include "mbed.h"
#include "display.h"

const int SLP_TIME = 1000; // Update once per second.

int main(void)
{
    Serial pc(USBTX, NC, 9600); // Use for debugging.
    // Note that bit sequence is the oposite of what I initially thought they 
    // would be. That is, pins are listed in low order to high order sequence.
    BusOut disBus(D9, D8, D7, D6, D5, D4, D3, D2); // The display.
    int myCount = 0; // Loop count. Rolls over at 18.
    
    // Test the wiring.
    
    display(18, disBus);  // All on (binary).
    pc.printf("Wiring test. All segments on.\n"); // Status message.
    ThisThread::sleep_for(2000); // Light all segments for 2 seconds.
    display(17, disBus);  // All off (binary).
    pc.printf("Wiring test All segments off.\n"); // Status message.
    ThisThread::sleep_for(2000); // Turn off all segments for 2 seconds.
    
    // Enter main loop.
    while(true) {
        display(myCount, disBus); // Display myCount (count).
        pc.printf("In main myCount = %x.\n", myCount); // Send count to PC.
        myCount++; // Increment the count.
        if (myCount > 18) myCount = 0; // Rollover!
        ThisThread::sleep_for(SLP_TIME);  // Display value for 1 second.
    }
}