/*
    Project: 21_7SegLU_v5
    File: main.cpp

    Counts through the digits 0 to 9 then DP on the 7-segment display.
    
    See external documentation for pin connections (very important).

    Written by: Dr. C. S. Tritt
    Created: 10/2/21 (v. 1.2)
*/
#include "mbed.h"

BusOut ssDisplay(D3, D4, D5, D6, D7, D8, D9, D10); // Segments, LSB to MSB.

int main() {
    // Declare and initialize array in one step.
    const int Segments[] 
        {0x81, 0xCF, 0x92, 0x86, 0xCC, 0xA4, 0xA0, 0x8F, 0x80, 0x84, 0x7F};

    while(true) { // Loop forever.
        for (int i = 0; i <= 10; i++) { // Cycle through digits.
            ssDisplay = Segments[i]; // Display current digit.
            ThisThread::sleep_for(1000); // Wait a second, then repeat.
        }
    }
}