#include "mbed.h"
 
AnalogIn analog_value(A0);
 
DigitalOut myled(LED1);
 
// Calculate the corresponding acquisition measure for a given value in mV
#define MV(x) ((0xFFF*x)/3300)
 
int main() {
    while(1) {      
        uint16_t meas = analog_value.read_u16(); // Converts and read the analog input value
        if (meas > MV(1000)) { // If the value is greater than 1000 mV toggle the LED
          myled = !myled;
          printf( "meas" );
          
        }
        wait(0.2); // 200 ms
    }
}
