//******************************************************************
//
//      Pont Bacalan
//
//  Logiciel de pilotage du Pont Bacalan:
//  - Afficheur Modbus autonome via RS422 4 fils
//  - 2 variateur en RS422 4 fils
//  - ? sorties logiques
//  - ? entrées logiques
// 
//
//********************************************************************

#include "mbed.h"

#include "Constantes.h"
#include "Variable.h"
#include "Pilote.h"
#include "Modbus.h"
#include "Synchronisation.h"
#include "Gemma.h"


#define VERSION_SOFT    10015

// Objet liaison série sur USB pour mode debug
Serial PC1(USBTX, USBRX) ;

// Objet liaison série vers les variateurs
Serial VAR_RD (p13, p14) ;
Serial VAR_RG (p9, p10) ;

// Objet pilote, de gestion du dialogue avec les variateurs
Pilote Rive_Droite (1) ;
Pilote Rive_Gauche (2) ;

// Chronomètre
Timer   Chrono ;

int main()
    {

    int debut_boucle_us;
    int fin_boucle_us;
    int Duree_us;

    F32 Valeur_F32 ;
    F32 Hauteur_Avant_F32 [TAILLE_TABLEAU_HAUTEURS] ;
    F32 Vitesse_Avant_F32 = 0.0 ;
       
    S16 Index ;
    
    // Initialisation du Modbus
    vModbus_Init(115200) ;
    vModbus_Start() ;

    //Initialisation des variables
    Init_Variables();
    Version_Soft = VERSION_SOFT ;
    
    Index = 0 ;
    while ( Index < TAILLE_TABLEAU_HAUTEURS )
        {
        Hauteur_Avant_F32 [ Index] = 0.0 ;
        Index++ ;
        }
    
    // Initialisation des pilotes de varialeur
    Rive_Droite.pPort = &VAR_RD ;
    Rive_Gauche.pPort = &VAR_RG ;
    
    Rive_Droite.Init ( 115200 , 8 , 1 ) ;
    Rive_Droite.Id = 1 ;
    Rive_Gauche.Init ( 115200 , 8 , 1 ) ;
    Rive_Gauche.Id = 2 ;
    
    Rive_Droite.Etalonnage (Hauteur_RD1_pts , Hauteur_RD1_mm , Hauteur_RD2_pts , Hauteur_RD2_mm ) ;
    Rive_Gauche.Etalonnage (Hauteur_RG1_pts , Hauteur_RG1_mm , Hauteur_RG2_pts , Hauteur_RG2_mm ) ;   
    
    //Ininialise_Rampes () ;
    //Affiche_Motif ( 0 ) ;
    
    // Initialisation du Gemma
    vGemma_Init () ;
    
    Chrono.start() ;
    
    while (true) 
        {
        // Lecture du temps en début de boucle
        debut_boucle_us = 0;//Chrono.read_us() ;
        Chrono.reset();
        fin_boucle_us = debut_boucle_us + (int)Periode_Scrutation_ms * 1000.0 ;  
              
        // Gestion du Modbus
        vModbus() ;
        
        // Gestion du mode de fonctionnement
        vGemma ( &Rive_Droite ,  &Rive_Gauche ) ;
        
        // Gestion de l'eclairage des rampes
        //vRampe_RGB () ; 
            
        // Duree de la boucle en µs
        Duree_us =  Chrono.read_us() - debut_boucle_us  ;
        Duree_Boucle_us = (S16)( Duree_us ) ;
        
        //PC1.printf("\r\n Duree : %d \r\n",Duree_us) ;
        //PC1.printf("\r\n Duree : %d / %X \r\n",Duree_us,Duree_Boucle_us);
        
        while( Chrono.read_us() < fin_boucle_us )
            {
            Rive_Droite.Reception () ;
            Rive_Gauche.Reception () ;
            vModbus() ;
            wait_us(200) ;
            }

          
        // Traitement des réponses des variateurs
        Mesure_RD = Rive_Droite.Mesure_Courante ;
        Vitesse_RD = Rive_Droite.Vitesse_Courante ;
        Hauteur_RD = Rive_Droite.Hauteur_Courante ;
        Etat_COM_RD = Rive_Droite.COM_OK  ;
        Compteur_Timeout_RD = Rive_Droite.Compteur_Timeout ;
        PC1.printf("\r\n RD : %i \t %i \t %i \t %i\r\n",Mesure_RD,Hauteur_RD,Vitesse_RD,Compteur_Timeout_RD);
        
        Mesure_RG = Rive_Gauche.Mesure_Courante ;
        Vitesse_RG = Rive_Gauche.Vitesse_Courante ;
        Hauteur_RG = Rive_Gauche.Hauteur_Courante ;
        Etat_COM_RG = Rive_Gauche.COM_OK  ;
        Compteur_Timeout_RG = Rive_Gauche.Compteur_Timeout ;
        PC1.printf("\r\n RG : %i \t %i \t %i \t %i\r\n",Mesure_RG,Hauteur_RG,Vitesse_RG,Compteur_Timeout_RG);
        
        Hauteur_P = ( Hauteur_RD + Hauteur_RG ) / 2 ;
        Ecart_Synchronisation =  Hauteur_RD - Hauteur_RG ; 
        //PC1.printf("\r\n Hauteur P : %i  \r\n",Hauteur_P);
        //PC1.printf("0") ;
        
        //Valeur_F32 = (F32)Hauteur_P - Hauteur_Avant_F32 [ TAILLE_TABLEAU_HAUTEURS - 1 ] ;
        Valeur_F32 = (F32) ( Vitesse_RG + Vitesse_RD ) / 2.0 ;
        Valeur_F32 = Valeur_F32 * 19.5 * 3.14156 / 100.0 ;
        Valeur_F32 = ( Vitesse_Avant_F32 + Valeur_F32 ) / 2.0 ;
        Vitesse_Avant_F32 = Valeur_F32 ;
        Vitesse_P = (S16) Valeur_F32 ;

        }

 }   



