//***********************************************************************************/
//
//          Variables globales du Pont Bacalan
//
//************************************************************************************/

#include <mbed.h>
#include "Constantes.h"

int i, j;



U16 usRegInputStart = REG_INPUT_START;
S16 Memoire_S16[REG_INPUT_NREGS];

//****************************************************************************
//
//      Initialisation des variables
//
//****************************************************************************
bool Init_Variables(void) 
    {
    // Initialise some registers
    for (i = 0; i < REG_INPUT_NREGS; i++) 
        {
        Memoire_S16[i] = 0;
        } 
    
    //Paramètres Memoire
    Sauvegarde_automatique = 0;
    Etalonnage_effectue = 0;
    Sauver_Vers_Flash =0;
    Etalonnage_en_cours=0;
    
    RAZ =0;
    
    Mode_Debug = 1;
    Periode_Scrutation_ms = 100 ;    // 0.1s

    Mode_Fonctionnement = MODE_ARRET ;
    Mode_Synchro = RD_SUIT_RG ;
    
    BTN_Arret = 1 ;
    BTN_Monte = 0 ;
    BTN_Descend = 0 ;
    
    BTN_Descend_RD = 0 ;
    BTN_Monte_RD = 0 ;
    
    BTN_Monte_RG = 0 ;
    BTN_Descend_RG = 0 ;
    
    Consigne_Vitesse_Auto = 2500 ;
    Consigne_Vitesse_Manu = 1500 ;
    Consigne_Haute_P = 450 ;
    Consigne_Basse_P= 5 ;


    Hauteur_mini = -10 ;
    Hauteur_maxi = 470 ;
    Vitesse_mini = 0 ;
    Vitesse_maxi = 4000 ;
    
    // Synchronisation
    Defaut_Mineur_Synchro = 5 ;
    Defaut_Majeur_Synchro = 10 ;
    Defaut_Critique_Synchro = 35 ;
    Correction_Synchro = 90 ;
    Anticipation_Synchro = 100 ;
    KP_Synchro = 2000 ;
    KI_Synchro = 100 ;
    KD_Synchro = 0 ;
    
    
    // Etalonnage
    Hauteur_RD1_mm = 0 ;    //0
    Hauteur_RD2_mm = 500 ;  //500
    Hauteur_RD1_pts = 100 ; //222
    Hauteur_RD2_pts = 3400 ; //822
    Hauteur_RG1_mm = 0 ;    //0
    Hauteur_RG2_mm = 500 ;  //500
    Hauteur_RG1_pts = 100 ; //219
    Hauteur_RG2_pts = 3400 ; //819
    
    // Parametres variateur  
    Param_Version_RD = 100 ;
    Param_Startup_RD = 1000 ;
    Param_Increment_RD = 50 ;
    Param_Seuil_Demarrage_RD = 500 ;
    Param_Acceleration_RD = 20 ;
    Param_Deceleration_RD = 20 ;
    Param_Kpv_RD = 1000 ;
    Param_Kiv_RD = 200 ;
    Param_Kdv_RD = 0 ;
    Param_Kav_RD = 1000 ;
    Param_Consigne_RD = 1500 ;

    //Parametres variateur rive gauche
    Param_Version_RG = 100 ;
    Param_Startup_RG = 1000 ;
    Param_Increment_RG = 50 ;
    Param_Seuil_Demarrage_RG = 500 ;
    Param_Acceleration_RG = 20 ;
    Param_Deceleration_RG = 20 ;
    Param_Kpv_RG = 1000 ;
    Param_Kiv_RG = 200 ;
    Param_Kdv_RG = 0 ;
    Param_Kav_RG = 1000 ;
    Param_Consigne_RG = 1500 ;

    return (1);
    }

