/*******************************************************************/
/*                                                                 */
/*                 Modbus                                          */
/*                                                                 */
/*  Gestion de la liaison Modbus esclave                           */
/*                                                                 */
/*                                                                 */
/*******************************************************************/
#ifndef _MODBUS_
#define _MODBUS_

#include "mbed.h"
#include <Serial.h>

#include "Constantes.h"
#include "Variable.h"

#include "time.h"



/***** Etats **********/
#define ARRET       0
#define ATTENTE     1
#define RECEPTION   2
#define RECU        3
#define TRAITE      4
#define EMISSION    5
#define FIN         6
#define ERREUR      7
#define TIMEOUT     8

/* ----------------------- Defines ------------------------------------------*/
#define MB_ADDRESSE_BROADCAST                 ( 0 )   /*! Modbus adresse de broadcast */
#define MB_ADDRESSE_MIN                       ( 1 )   /*! Smallest possible slave address. */
#define MB_ADDRESSE_MAX                       ( 247 ) /*! Biggest possible slave address. */
#define MB_FUNC_NONE                          (  0 )
#define MB_FUNC_READ_COILS                    (  1 )
#define MB_FUNC_READ_DISCRETE_INPUTS          (  2 )
#define MB_FUNC_WRITE_SINGLE_COIL             (  5 )
#define MB_FUNC_WRITE_MULTIPLE_COILS          ( 15 )
#define MB_FUNC_READ_HOLDING_REGISTER         ( 3 )
#define MB_FUNC_READ_INPUT_REGISTER           (  4 )
#define MB_FUNC_WRITE_REGISTER                (  6 )
#define MB_FUNC_WRITE_MULTIPLE_REGISTERS      ( 16 )
#define MB_FUNC_READWRITE_MULTIPLE_REGISTERS  ( 23 )
#define MB_FUNC_DIAG_READ_EXCEPTION           (  7 )
#define MB_FUNC_DIAG_DIAGNOSTIC               (  8 )
#define MB_FUNC_DIAG_GET_COM_EVENT_CNT        ( 11 )
#define MB_FUNC_DIAG_GET_COM_EVENT_LOG        ( 12 )
#define MB_FUNC_OTHER_REPORT_SLAVEID          ( 17 )
#define MB_FUNC_ERROR                         ( 128 )
/* ----------------------- Type definitions ---------------------------------*/
    typedef enum
{
    MB_EX_NONE = 0x00,
    MB_EX_ILLEGAL_FUNCTION = 0x01,
    MB_EX_ILLEGAL_DATA_ADDRESS = 0x02,
    MB_EX_ILLEGAL_DATA_VALUE = 0x03,
    MB_EX_SLAVE_DEVICE_FAILURE = 0x04,
    MB_EX_ACKNOWLEDGE = 0x05,
    MB_EX_SLAVE_BUSY = 0x06,
    MB_EX_MEMORY_PARITY_ERROR = 0x08,
    MB_EX_GATEWAY_PATH_FAILED = 0x0A,
    MB_EX_GATEWAY_TGT_FAILED = 0x0B
} Code_Erreur_t ; 

#define TAILLE_MESSAGE_MAXI  20

typedef struct
    {
    U8  Etat_U8 ;
    U8  Code_Erreur ;
    U8  Trame_Recue_aU8 [TAILLE_MESSAGE_MAXI] ;
    U8  Nb_Caracteres_Recus_U8 ;
    U8  Trame_Reponse_aU8 [TAILLE_MESSAGE_MAXI] ;
    U8  Nb_Caracteres_A_Emettre_U8 ;
    }   Ordre_Modbus_t ;

#define TAILLE_PILE_ORDRES  5


 extern  volatile    Ordre_Modbus_t  Ordres[TAILLE_PILE_ORDRES] ;


 
 extern void    vModbus_Init(int Baudrate) ;   
 extern void    vModbus_Start() ;
 extern void    vModbus_Stop() ;
 extern void    vModbus_Reset() ;
 extern void    vModbus() ;




#endif