#include "mbed.h"

class Watchdog {
public:
//load timeout value and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1; //Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16; //WD has /4 prescaler and PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3; //Enabled and Reset
        kick();
    }
    //kick the dog by feeding required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

DigitalOut myled2(p25);
PwmOut myled3(p21);
DigitalIn pb(p24);
DigitalIn pwmup(p22);
DigitalIn pwmdown(p23);
Watchdog wdt;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int main() {
    // Part 1
    pb.mode(PullUp); // The variable left_pb will be zero when the pushbutton for moving the player left is pressed
    pwmup.mode(PullUp);
    pwmdown.mode(PullUp);
    
    // Part 2
    myled3.period(0.01f);
    volatile float duty = 0.50f;
    myled3.write(duty);
    
    // Watchdog
    int count = 0;
    // on reset indicate a watchdog reset on LED 4 or 3
    if((LPC_WDT->WDMOD >> 2) & 1)
        led4 = 1; else led3 = 1;
    // set a 10 second timeout on WD timer hardware, longer than worst case main loop execution time
    wdt.kick(5.0);
    
    // resets watchdog timer once every loop
    while(1) {
        //watchdog stuff, ldes 1 and 2 indicate normal operation
        led1 = 1;
        wait(0.05);
        led1 = 0;
        led2 = 1;
        wait(0.05);
        // Part 1
        while(pb == 0) {
            myled2 = 0;
        }
        myled2 = 1;
        
        // Part 2
        if(pwmup == 0 && duty < 1.00f) {
            //duty = duty + 0.001f;
            duty += 0.05f;
            //duty = 1.0f;
            myled3.write(duty);
            while(pwmup == 0) {}
        }
        if(pwmdown == 0 && duty > 0.00f) {
            //duty = duty - 0.001f;
            duty -= 0.05f;
            //duty = 0.0f;
            myled3.write(duty);
            while(pwmdown == 0) {}
        }
        //watchdog fault simulation
        if (count == 100) while (1) {};
        // led 2 stays on during the fault
        led2 = 0;
        count++;
        //end of main loop, kick the WD
        wdt.kick();
    }
}
