#include <mbed.h>
#include <mpr121.h>

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

InterruptIn interrupt(p26); //interrupt receiver

//i2c bus on pins 28(SDA) and 27(SCL)
I2C i2c(p28, p27);

//Setup the Mpr121:
//ctor
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

//key hit interrupt routine
void fallInterrupt() {
    int key_code = 0;
    int i = 0;
    int value = mpr121.read(0x00);
    value += mpr121.read(0x01) << 8;
    //LED demo mod
    i = 0;
    //puts key number out to LEDs for demo
    for (i = 0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
    }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
}

int main() {
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);    
}