#include "mbed.h"

DigitalOut myled2(p25);
PwmOut myled3(p21);
DigitalIn pb(p24);
DigitalIn pwmup(p22);
DigitalIn pwmdown(p23);

int main() {
    // Part 1
    pb.mode(PullUp); // The variable left_pb will be zero when the pushbutton for moving the player left is pressed
    pwmup.mode(PullUp);
    pwmdown.mode(PullUp);
    
    // Part 2
    myled3.period(0.01f);
    volatile float duty = 0.50f;
    myled3.write(duty);
    
    while(1) {
        // Part 1
        while(pb == 0) {
            myled2 = 0;
        }
        myled2 = 1;
        
        // Part 2
        if(pwmup == 0 && duty < 1.00f) {
            //duty = duty + 0.001f;
            duty += 0.05f;
            //duty = 1.0f;
            myled3.write(duty);
            while(pwmup == 0) {}
        }
        if(pwmdown == 0 && duty > 0.00f) {
            //duty = duty - 0.001f;
            duty -= 0.05f;
            //duty = 0.0f;
            myled3.write(duty);
            while(pwmdown == 0) {}
        }
    }
}
