#include "mbed.h"
#include "Speaker.h"

// Speaker test program - euro police style siren now using new Speaker class method
// for documentation see http://mbed.org/users/4180_1/notebook/using-a-speaker-for-audio-output/
// can also be used to play a song, if you have all of the notes and durations
// for musical note frequencies see http://en.wikipedia.org/wiki/Piano_key_frequencies

float t = 2.5; //tempo controller

int main()
{
// setup instance of new Speaker class, mySpeaker using pin 22
// the pin must be a PWM output pin
    Speaker mySpeaker(p22);
    //DigitalOut shutdown(p17);
    // Ramblin Wreck
    while(1) {
//first verse using lower octave because the speaker has too much sauce
        mySpeaker.PlayNote(783.991,1.0/t,0.1); // G
        mySpeaker.PlayNote(698.456,0.5/t,0.1); //F
        mySpeaker.PlayNote(622.254,0.9/t,0.1); //E flat
        mySpeaker.PlayNote(0.0,0.1/t,0.0); //separation between the same notes
        mySpeaker.PlayNote(622.254,0.4/t,0.1); //E flat
        mySpeaker.PlayNote(0.0,0.1/t,0.0);
        mySpeaker.PlayNote(622.254,1.0/t,0.1); //E flat
        mySpeaker.PlayNote(698.456,0.5/t,0.1); //F
        mySpeaker.PlayNote(783.991,0.9/t,0.1); // G
        mySpeaker.PlayNote(0.0,0.1/t,0.0);
        mySpeaker.PlayNote(783.991,0.4/t,0.1); // G
        mySpeaker.PlayNote(0.0,0.1/t,0.0);
        mySpeaker.PlayNote(783.991,0.5/t,0.1); // G
        mySpeaker.PlayNote(698.456,0.5/t,0.1); //F
        mySpeaker.PlayNote(622.254,0.5/t,0.1); //E flat
        mySpeaker.PlayNote(698.456,0.4/t,0.1); //F
        mySpeaker.PlayNote(0.0,0.1/t,0.0);
        mySpeaker.PlayNote(698.456,0.4/t,0.1); //F
        mySpeaker.PlayNote(0.0,0.1/t,0.0);
        mySpeaker.PlayNote(698.456,0.5/t,0.1); //F
        mySpeaker.PlayNote(622.254,1.0/t,0.1); //E flat
        mySpeaker.PlayNote(587.330,0.5/t,0.1); //D
        mySpeaker.PlayNote(622.254,2.5/t,0.1); //E flat
        mySpeaker.PlayNote(0.0,0.5/t,0.0); //rest then repeat
    }
}

