//--------------------------------------------------------------
// IIR filter: Cascade strucrure
//
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/22
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4922Single.hpp"
#include "IIR_Coefficients.hpp"
#include "IIR_Cascade.hpp"

using namespace Mikami;

// sampling frequency
const float FS_ = 10.0e3f;

Adc adc_(A0);
Dac dacA_(Dac::DAC_A);
Ticker timer_;           // for timer interrupt

IirCascade<ORDER_/2> iirLpf(g0_, ck_);

// Called every 0.1 ms
void TimerIsr()
{
    float xn = adc_.Read(); // input
    
    // Execute IIR filter
    float yn = iirLpf.Execute(xn);
    
    dacA_.Write(yn);        // output
}

int main()
{
    timer_.attach_us(&TimerIsr, 1.0e6f/FS_);

    while (true) {}    // infinite loop
}
