//--------------------------------------------------------------
//  Coefficients for IIR filter, Order = 6
//--------------------------------------------------------------
// Lowpass filter
// Elliptic character
// Sampling frequency:      10.00 kHz
// Cutoff frequency:         0.50 kHz
// Ripples in passband:      0.50 dB
// Attenuation in stopband: 40.00 dB

#include "Biquad.hpp"

using namespace Mikami;

const int ORDER_ = 6;

const Biquad::Coefs ck_[ORDER_/2] = {
    { 1.755914E+00f, -7.841154E-01f, -1.200026E+00f, 1.0f},
    { 1.834544E+00f, -9.093489E-01f, -1.822074E+00f, 1.0f},
    { 1.881858E+00f, -9.801108E-01f, -1.872779E+00f, 1.0f}};

const float g0_ = 1.080597E-02f;
