//--------------------------------------------------------------
// IIR filter ---- Cascade structure
// Copyright (c) 2014 MIKAMI, Naoki, 2014/07/15
//--------------------------------------------------------------

#ifndef IIR_CASCADE_HPP
#define IIR_CASCADE_HPP

#include "mbed.h"
#include "Biquad.hpp"

namespace Mikami
{
    // IIR filter -- Cascade structure
    template<int order> class IirCascade
    {
    private:
        Biquad hk_[order];  // Elements of cascade structure
        const float G0_;    // gain factor
 
        IirCascade(const IirCascade&);
        IirCascade& operator=(const IirCascade&);
 
    public:
        IirCascade(float g0, const Biquad::Coefs ck[])
                  : G0_(g0)
        {
            for (int k=0; k<order; k++)
                hk_[k] = Biquad(ck[k]);
        }

        float Execute(float xn)
        {
            float yn = G0_*xn;
            for (int k=0; k<order; k++)
                yn = hk_[k].Execute(yn);
                
            return yn;
        }
        
        void Clear()
        {
            for (int k=0; k<order; k++)
                hk_[k].Clear();
        }
    };
}
#endif  // IIR_CASCADE_HPP

