//--------------------------------------------------------------
// Hilbert transform filter
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/23
//--------------------------------------------------------------

#ifndef HILBERT_TRANSFORM_HPP
#define HILBERT_TRANSFORM_HPP

#include "mbed.h"

namespace Mikami
{
    template<int order> class Hilbert
    {
    private:
        const float *const hm_; // pointer for filter coefficients
        float xn_[order+1];     // buffer for inputs

        Hilbert(const Hilbert&);
        Hilbert& operator=(const Hilbert&);
    public:
        Hilbert(const float hk[]) : hm_(hk)
        {
            for (int k=0; k<=order; k++) xn_[k] = 0.0;
        }
        
        // yI: in-phase signal
        // yQ: quadrature signal
        void Execute(float xin, float& yI, float& yQ)
        {
            yQ = 0.0;
            xn_[0] = xin;

            for (int k=0; k<=order/4; k++)
                yQ = yQ + hm_[k]*(xn_[2*k] - xn_[order-2*k]);
            yI = xn_[order/2];              // in-phase signal

            for (int k=order; k>0; k--)
                xn_[k] = xn_[k-1];          // move input signals        
        }
    };
}
#endif  // HILBERT_TRANSFORM_HPP

