//--------------------------------------------------------------
// Frequency converter
// Copyright (c) 2014 MIKAMI, Naoki,  2014/06/23
//--------------------------------------------------------------

#include "mbed.h"
#include "AdcInternal.hpp"
#include "MCP4922Single.hpp"
#include "HilbertTransform.hpp"
#include "coefsHilbert94.hpp"
#include "DC_Cut_Coefficients.hpp"
#include "Biquad.hpp"
#include "TwoPhaseGenerator.hpp"

using namespace Mikami;

const float FS_ = 10.0e3f;
Adc adc_(A0);
Dac dac_(Dac::DAC_A);

Ticker timer_;          // for timer interrupt

Hilbert<ORDER_> ht(hm_);
Biquad DcCut(c1_);      // DC cut filter
TwoPhaseGenerator sinCos_(100.0f, FS_); // 100.0 Hz

void TimerIsr()
{
    float yI, yQ, cosx, sinx;

    float xn = adc_.Read(); // input
    
    xn = DcCut.Execute(g0_*xn);     // DC cut
    ht.Execute(xn, yI, yQ);         // Hilbert transform
    sinCos_.Generate(cosx, sinx);   // cos and sin generator
    float yn = yI*cosx - yQ*sinx;   // conversion
    
    dac_.Write(yn);    // output
}

int main()
{
    timer_.attach_us(&TimerIsr, 1.0e6f/FS_);
    while (true) {}    // infinite loop
}

